/**Table: daily_expense_by_branch**/
select b.date,b.center_id,b.zone_id,b.branch_id,center.center_name,center.center_no,
sum(ld.loan_amount) as loan_amount_daily, 
sum(lw.loan_amount) as loan_amount_weekly, 
sum(lm.loan_amount) as loan_amount_monthly, 
sum(sd.amount) as saving_withdraw_daily, 
sum(sw.amount) as saving_withdraw_weekly,
sum(sm.amount) as saving_withdraw_month,
sum(d.amount) as dps_withdraw 
from balance b 

left join loan as ld on (ld.loan_id=b.loan_id and ld.loan_type=1)
left join loan as lw on (lw.loan_id=b.loan_id and lw.loan_type=2)
left join loan as lm on (lm.loan_id=b.loan_id and lm.loan_type=3)

left join saving_account_transaction as sd on (sd.transaction_id=b.saving_transaction_id and sd.account_type=1 and sd.transaction_type=2)
left join saving_account_transaction as sw on (sw.transaction_id=b.saving_transaction_id and sw.account_type=2 and sw.transaction_type=2)
left join saving_account_transaction as sm on (sm.transaction_id=b.saving_transaction_id and sm.account_type=3 and sm.transaction_type=2)
left join dps_account_transaction  as d on (d.transaction_id=b.dps_transaction_id and d.transaction_type=2) 
left join center on center.center_id=b.center_id
group by b.date,b.branch_id,b.center_id 
having (
loan_amount_daily is not null
or loan_amount_weekly is not null
or loan_amount_monthly is not null
or saving_withdraw_daily is not null
or saving_withdraw_weekly is not null
or saving_withdraw_month is not null
or dps_withdraw is not null
)





